/* SensorStatus.nc -- Interface to get status from sensor system.
 *		The "other side" of the SensorControl interface.
 *	User requests status information.
 *  Gets signaled back after each cycle.
 *  Can get full results from global RoboStatusMsg.
 *
 * Authors:		M.Schippling
 */

interface SensorStatus
{
	/** Sign up for or cancel status ready signaling.
	 *  The data argument is implementation specific.
	 *  Result status is provided by signal of statusReady().
	**/
	command result_t doStatus( uint8_t data );
  
	/** Event sent when data acquisition cycle is completed,
	 **    user should implement.
	 ** @param status -- interesting status bits
	 **  see various status enums for values
	**/
	async event result_t statusReady( uint8_t status );

}
