/* SensorControl.nc -- Interface to Control Sensor data acquisition.
 *		The master side of the SensorStatus interface.
 *	Driven by an external request or timer.
 *  Puts results into global RoboStatusMsg or RoboControl.
 *
 * Authors:		M.Schippling
 */

interface SensorControl
{
  /** init() -- Initialize whatever whenever
   *  start() -- Could enable sensor
   *  stop() -- Could disable sensor
   *
   *  @return SUCCESS.
   */
  command result_t init();
  command result_t start();
  command result_t stop();
   
  /** set 'global' variable pointers as needed
   */
  command result_t setGlobals(
  					 TOS_Msg *statmsg,		 // status return
  					 RoboCmdMsg *cmdbuf,	 // current command
  					 RoboControl *cntlbuf ); // internal data
  
  /** Initiate a data acquisition/conversion cycle.
   *  Called by user or external timer function.
   *  Results are posted into the global RoboStatusMsg
   *  Users can get synchronized results using the SensorStatus I/F.
   */
  command result_t dACycle();
  
  /** Check sensor status, immediate response.
   *	Copy data from sensor to statp block.
   *  @return bitmask of interesting status
   *  see various sensor enums for values
   */
  command uint8_t getStatus();

}
