/** HSMotorsC.nc -- Config file for the RoboCar Motor control
**/

includes RoboHardware;
includes RoboMsg;

configuration HSMotorsC
{
  provides interface Motors;
  provides interface SensorControl as MotorControl;
  provides interface SensorStatus as MotorStatus;
}
implementation
{
  components HSMotorsM,
			 HPLT1pwmM,
			 BumpEncC,
			 DataStoreC,
			 TimerC, LedsC;

  Motors = HSMotorsM;
  MotorControl = HSMotorsM;
  MotorStatus = HSMotorsM;
  
  HSMotorsM.Pwm -> HPLT1pwmM;
  HSMotorsM.EncoderStatus -> BumpEncC.EncoderStatus;
  HSMotorsM.DataStore -> DataStoreC;
  HSMotorsM.Timer -> TimerC.Timer[unique("Timer")];
  HSMotorsM.Leds -> LedsC;
  
}
