/**	HPLPortCM.nc -- Implement HPLPort interface on ATMEGA port C.
**/

module HPLPortCM
{
	provides interface HPLPort;
}
implementation
{

   /**
    * Initialize the module and port.
    * If input enable internal pullups.
    * If output init all pins to output=0
    *  @param direction -- 0 == input, !0 == output
    *  @return Always returns SUCCESS.
   */
	command result_t HPLPort.init( uint8_t direction )
	{
		// Set pin directions...
		if( direction == 0 )
		{
		 	// DDRC==0 is input and turn on internal pullups
			outp( 0x00, DDRC );
			outp( 0xff, PORTC );
		}
		else
		{
		 	// DDRC==1 is output and turn off outputs
			outp( 0x00, PORTC );
			outp( 0xff, DDRC );
		}

		return SUCCESS;
	}

	/**
	 * read the value of an input port
	 *  @return  8 bit unsigned value.
	*/
	command uint8_t HPLPort.read()
	{
		return inp( PINC );
	}

	/**
	 * write the given 8 bit value to the port. 
	 *  @param value -- data to write
	 *  @return Always returns SUCCESS.
	*/
	command result_t HPLPort.write( uint8_t value )
	{
		outp( value, PORTC );
		return SUCCESS;
	}
	
	/**
	 * set the given bits in 8 bit value at the port. 
	 *  sets mask 1 bits on output, leaves 0 bits alone.
	 *  
	 *  @param mask -- mask to write
	 *  @return Always returns SUCCESS.
	*/
	command result_t HPLPort.setBits( uint8_t mask )
	{
		// get current port values and mask with argument
		uint8_t value = call HPLPort.read();
		value |= mask;
		outp( value, PORTC );
		return SUCCESS;
	}
	
	/**
	 * clear the given bits in 8 bit value at the port. 
	 *  clears mask 1 bits on output, leaves 0 bits alone.
	 *  
	 *  @param mask -- mask to write
	 *  @return Always returns SUCCESS.
	*/
	command result_t HPLPort.clrBits( uint8_t mask )
	{
		// get current port values and mask with argument
		uint8_t value = call HPLPort.read();
		value &= ~mask;
		outp( value, PORTC );
		return SUCCESS;
	}

}
