/** WriteThread.java -- Autorun status request send.
 *   Assumes that you start another new one for each test loop.
**/
package com.etantdonnes.tinyos.robo;

import net.tinyos.packet.PacketSource;


public class WriteThread implements Runnable
{
	public RoboStatReq statReq = new RoboStatReq();

	protected int[] devs = null; // destination addrs
	protected int numdevs = 0;	 // number of reMotes in devs list
	protected int delay = 0;	 // wait ms between auto messages
	
	protected PacketSource roboComm = null;
	protected Thread threadID = null;
	protected LogMessage log = null;
	protected boolean runme = true;

    
	public WriteThread( PacketSource rc, LogMessage l, RoboStatReq sr,
						int d, int[] ds, int n )
    {
    	roboComm = rc;
    	log = l;
    	statReq = sr;
    	// always shut off the retyr mechanism....
    	statReq.runstate |= RoboStatReq.SRSnorpt;
    	delay = d;
    	devs = ds;
    	numdevs = n;
    	
		 // start the auto write thread --
    	threadID = new Thread( this, "WriteThread" );
    	threadID.start();
	}
    
    /** terminate with extreme prejudice
     *   force run() to break as best we can
     */
    public void kill()
    {
        runme = false;

        // interrupting Packetizer seems to make it close it's connection
        //  so we'll just rely on the timeout to get the loop to break.
      //  threadID.interrupt();  // does this work?..apparently....
        
        // wait for things to complete
        try { threadID.join(); } catch( Exception e ) { }
    }

   /** From the Runnable interface
    ***  What we do in the autorun thread to send repeated messages.
    **/
    public void run()
    {
		boolean rval;
		long now;
		byte data[];
		int i;

		long start = System.currentTimeMillis();
		
		log.startLog( start );

		try
		{
          while( runme )
		  {
          	i = 0;  // destAddr counter
          	do
          	{
				// set destination Mote ID
				statReq.destAddr = devs[i];
				// get data buffer to send
				data = statReq.dataGet();
				now = System.currentTimeMillis();
				
				// NOTE: when using micaz's the message cycle time
				//   is small enough that the reply read can get
				//   ahead of the write log such that there is nothing
				//   to match the reply to when logging. So....
				//   Grab the log until the write is done and then
				//    let read have a chance. Hopefully this doesn't
				//    bollux things up too much.
				synchronized( log )
				{
					rval = roboComm.writePacket( data );
					log.logWrite( now, rval, statReq );
				}
				
				// wait around if we want to
				if( delay != 0 );
					Thread.sleep( delay );
	
          	// note stops on first -1 destaddr,
			// but sends one as a bcast msg if it is the first ID
          	} while( (devs[i] != -1) && (++i < numdevs) );
		  }
          
		  // hang around for a bit to let reads catch up
		  Thread.sleep(2000);
		}
		catch( Exception e )
		{
			System.err.println( "WriteThread exception " + roboComm.getName() +
					": " + e.getMessage() );
		}
    	
		// finish logging good stuff
		log.stopLog();

        return; // its all over now
    }


} // end'o'WriteThread
