/** RadioCommTest.java -- Test program for Mote and RoboII communications.
 *    Doc TBD...
 *  Taken loosly from Listen.java,v 1.3.2.3 2003/08/20
**/

import java.io.*;
import java.text.NumberFormat;
import java.util.Vector;

import com.etantdonnes.tinyos.robo.*;

import net.tinyos.packet.*;
import net.tinyos.util.*;
import net.tinyos.message.*;
import net.tinyos.tools.*;


public class RadioCommTest
{
	static final int DEFID = 1;		// default Mote devID
	static final int MAXDEV = 10;	// number of re-Motes
	
	public static void main(String args[]) throws Exception
	{
		PrintStream o = null;
		PacketSource rc = null;
		
		if (args.length == 0)
		{
			o = System.out;
		}
		else if (args.length == 1)
		{
			o = new PrintStream( new FileOutputStream( args[0] ) );		
		}
		else
		{
			System.err.println(
				"usage: java RadioCommTest [outfile]");
			System.exit(2);
		}
		
		// get the TOS connection
		rc = BuildSource.makePacketSource();
		if (rc == null)
		{
			System.err.println(
		"Invalid packet source (check your MOTECOM environment variable)");
			System.exit(2);
		}
		rc.open(PrintStreamMessenger.err);
		
		// set decent read ack timeout value
		//  note: requires final->public mod in Packetizer.java
		((Packetizer)rc).ACK_TIMEOUT = 50;
		((Packetizer)rc).ACK_TIMEOUT = 10;
		
		// roll with it
		RadioCommTest rct = new RadioCommTest( rc, o );

		System.exit(0);
	} // end'o'main

	
	/**
	 * 
	 */
	public RadioCommTest( PacketSource rc, PrintStream o )
	{
		int autodelay = 50;		// wait ms between auto messages
		
		int[] destAddrs = new int[MAXDEV+1];	// destination addrs
		destAddrs[0] = DEFID; // initial ID setting for my own convenience
		int numdevs = 1;	// number of valid reMoteIDs in destAddrs[]
		
		int sparams[] = new int[10];	// status param parsing array
		int cparams[] = new int[10];	// command param parsing array
		int rparams[] = new int[10];	// repeat loop param parsing array

		WriteThread writeThread = null;
		ReadThread readThread = null;
	
		RoboStatReq statReq = new RoboStatReq();
		RoboStopReq stopReq = new RoboStopReq();
		RoboStartReq startReq = new RoboStartReq();
		
		PrintStream out = null;
		PacketSource roboComm = null;
	
		int i; // convenient index
		
		roboComm = rc;
		out = o;
		
		try
		{
			LogMessage onelog = new LogMessageOne( System.out );
			readThread = new ReadThread( roboComm, onelog );

			RoboMessage sendReq = null;

			// note: STREAM-f*****g-Tokenizer isn't able to set delims other than 
			//  whitespace right...so it's all WS and no commas from here on in.
			//  It's deprecated anyway...
			StreamTokenizer inp = new StreamTokenizer( System.in );
			inp.eolIsSignificant( true );
			inp.lowerCaseMode( true );
			inp.parseNumbers();

			boolean run = true;		// run the input loop while true
			boolean exec = false;	// exec a singleton command if true
			
			while( run )
			{
				System.out.print( "?>> " );

				// get something from stdin
				int ttype = inp.nextToken();
				// if it is text, then get the first char as a command
				if( ttype == StreamTokenizer.TT_WORD )
					ttype = (int) inp.sval.charAt( 0 );

				// do something with it
				switch( ttype )
				{
					case '?':	// print cmds
					{
						System.out.println( "SPACE--delimiters!!\n" +
							"<RTN> -- get status\n" +
							"Command movetime turntime mspd tspd...\n" +
							"DestAddrs [...] (-1 for bcast)\n" +
							"Halt\n" +
							"Run delay logtype time\n" +
							"Status statbits txstrength\n" +
							"Quit" );
					}
					break;

					case 'q':	// bailout
					case StreamTokenizer.TT_EOF:
					{
						run = false;
						System.out.println( "bye bye" );
					}
					break;

					case 'd':	// set destination IDs
					{
						// if the first id is -1 then we want
						//  to do a bcast message. In this case
						//  all of the real ids should be supplied
						//  after, e.g.:   -1 1 2 3 4 5  
						//  so autorun knows from whom to expect replies.
						// If just doing a singleton bcast only the -1 is needed
						// If doing round-robin, then leave off the -1.
						i = 0;
						while( (ttype = inp.nextToken()) !=
								StreamTokenizer.TT_EOL )
						{
							destAddrs[i++] = (int) inp.nval;
						}
						
						// save number of valid entries
						if( i != 0 )	numdevs = i;
						
						System.out.print( "DestAddr set (" + numdevs + "): " );
						i = 0;
						do
						{
							System.out.print( (destAddrs[i] == -1) ?
									"bcast to : " : (destAddrs[i] + " ") );
							
						} while( ++i < numdevs );
						
						System.out.println("");
					}
					break;

					case 'r':	// autorun test
					{
						// wax the autorun test if it's going
						// otherwise start one up
						if( writeThread != null )
						{
							writeThread.kill();
							readThread.setLogging( onelog );
							writeThread = null;
						}
						else
						{
							i = 0;
							while( (ttype = inp.nextToken()) !=
									StreamTokenizer.TT_EOL )
							{
								rparams[i++] = (int) inp.nval;
							}
							autodelay = rparams[0];
							boolean logtype = (rparams[1] != 0);
							int time = rparams[2] * 1000;
							
							// use current statReq and destAddrs settings
							// setup logging,
							//  if true use loop log else use singleton
							LogMessage l;
							if( logtype )
								l = new LogMessageTest( out,
														destAddrs, numdevs,
														autodelay,
														statReq.runstate,
														statReq.txstrength );
							else
								l = onelog;
							
							readThread.setLogging( l );
							// fire it up
							writeThread =
								new WriteThread( roboComm, l, statReq,
											 autodelay, destAddrs, numdevs );
							
							// if a test time was specified then wait here...
							if( time != 0 )
							{
								Thread.sleep( time );
								writeThread.kill();
								readThread.setLogging( onelog );
								writeThread = null;
							}
						}
					}
					break;
					
					case 'h':	// send halt
					{
						sendReq = stopReq;
						exec = true;
					}
					break;

					case 'c':	// send command
					{
						// if it is not EOL then get parameter values
						// keep old param values on each pass
						i = 0;
						while( (ttype = inp.nextToken()) !=
								StreamTokenizer.TT_EOL )
						{
							cparams[i++] = (int) inp.nval;
						}
						startReq.movetime   = cparams[0];
						startReq.turntime   = cparams[1];
						startReq.movespeed  = cparams[2];
						startReq.turnspeed  = cparams[3];
						startReq.pingA0cnt  = cparams[4];
						startReq.pingB0cnt  = cparams[5];
						startReq.targetData = cparams[6];
						startReq.otherData  = cparams[7];

						// get data buffer to send
						sendReq = startReq;
						exec = true;
					}
					break;

					case 's':	// set stat params & send status req
					{
						// if it is not EOL then get parameter values
						// keep old param values on each pass
						i = 0;
						while( (ttype = inp.nextToken()) !=
								StreamTokenizer.TT_EOL )
						{
							sparams[i++] = (int) inp.nval;
						}
						// set control bits for ACK and msg params
						statReq.runstate = sparams[0];
						statReq.txstrength = sparams[1];
						
						System.out.println(
								"Auto Delay set to: " + autodelay +
								"  StatReq: " + statReq.toString() );
					}
					// fall through...
					case StreamTokenizer.TT_EOL:	// default send statreq
					default:
						sendReq = statReq;
						exec = true;
					
				} // end switch(ttype)

				// empty input stream just in case
				while( ttype != StreamTokenizer.TT_EOL ) 
					ttype = inp.nextToken();
				
				// if we have a command, do it
				if( exec )
				{
					exec = false; // never again
					// set destination Mote ID
					sendReq.destAddr = destAddrs[0];
					// get data buffer to send
					byte[] data = sendReq.dataGet();
					RoboMessage.printBytes( out, data, "TX" );
					// do the retry if write ACK fails,
					//  unless we have shut them off in the statreq
					if( (roboComm.writePacket( data ) == false) &&
						(statReq.runstate == 0) )
					{
						// failed ACK, retry
						boolean rval = roboComm.writePacket( data );
						System.out.println( "write ACK failed, retry " +
							(rval ? "OK" : "NFG" ) );
					}
				}

			} // while( run );

		} catch( Exception e )
		{
			System.err.println("Command Loop Error on " + roboComm.getName() +
						": " + e);
		}
			
		if( writeThread != null )	writeThread.kill();
		if( readThread != null )	readThread.kill();

	}

} // end'o'RadioCommTest
