/* HSMotors.nc -- Interface for Pulse Width Modulation control of
 *					modified "hobby-servo" motors
 *                  using Timer1A,B outputs defined in HPLT1pwmM.nc:
 * 						PWM1Aout   PB5		Motor1 (left) PWM
 *						PWM1Bout   PB6		Motor2 (right) PWM
 *
 * Authors:		M.Schipling
 */

// Uses the hardware PWM interface and adds useful motor control.
//  Speed is an 8-bit number from 1-255 which sets
//     the relative On/Off ratio for both motors.
//  stopMotors() set the speed to 0 and turn off the outputs entirely.
//  setDiff() sets a speed differential between the motors.

interface HSMotors
{
  /** Init()
   *  Setup the Timer1A,B for Phase and Frequency correct PWM
   *   with default duration of 20ms and outputs OFF.
   *  @return SUCCESS.
   */
  command result_t init();
  
  /** stopMotors()
   *    Stop both the PWM outputs and set to 0.
   *  @return nada.
   */
  command void stopMotors();

  /** forward()
   *    Start robot moving forward at the given relative speed.
   *  @return nada.
   */
  command void forward( uint8_t s );

  /** backward()
   *    Start robot moving backward at the given relative speed,
   *  @return nada.
   */
  command void backward( uint8_t s );

  /** rotateCW()
   *    Start robot rotating clockwise -- right turn, minus angle --
   *	 at the given relative speed.
   *  @return nada.
   */
  command void rotateCW( uint8_t s );

  /** rotateCCW()
   *    Start robot rotating counter-clockwise -- left turn, plus angle --
   *	 at the given speed.
   *  @return nada.
   */
  command void rotateCCW( uint8_t s );

  /** jogASpeed()
   *    Jog Left--MotorA speed (pulsewidth setting) by given amount.
   *  @return nada.
   */
  command void jogASpeed( int8_t d );

  /** jogBSpeed()
   *    Jog Right--MotorB speed (pulsewidth setting) by given amount.
   *  @return nada.
   */
  command void jogBSpeed( int8_t d );

  /** enableSpdCntl()
   *    En/Dis-able encoder driven speed control in check*Spd() methods.
   *	TRUE enables, FALSE disables.
   *	Used to take motor control during Target Tracking.
   *  @return nada.
   */
  command void enableSpdCntl( bool en );

  /** checkASpeed()
   *    Check the Left--MotorA speed against given count value.
   *	Adjust MotorA pulse width if necessary
   *	 and save new pw setting in speed table for use later.
   *	Also increments distance count so we can check how far we went.
   *  @return nada
   */
  command void checkASpeed( uint8_t count );

  /** checkBSpeed()
   *    Check the Right--MotorB speed against given count value.
   *	Adjust MotorB pulse width if necessary
   *	 and save new pw setting in speed table for use later.
   *	Also increments distance count so we can check how far we went.
   *  @return nada
   */
  command void checkBSpeed( uint8_t count );

  /** getDistance()
   *  @return the distance traveled in clicks during this motion.
   *			Note: this will be calculated from the sum of the
   *			 click counts from both wheels. It will always be
   *			 positive, even during rotations.
   *			Note: value is ~4*CM traveled because it's really the
   *			 number of encoder clicks that are reported when using
   *			 check*Spd() and clicks happen about 2/CM.
   */
  command uint16_t getDistance();

}
