/* HPLT3capture.nc -- Interface to use Timer3 to time pulses on port PE7.
 *	Defaults to values for 16 bit resolution of 1.088us per bit.
 *
 * Authors:		M.Schippling
 */

interface HPLT3capture
{
  /** Init()
   *  Setup the Timer3 for normal up-counting
   *   with default resolution of 1.088us max duration of ~71ms.
   *  Enable input interrupt/capture on PE7.
   *  If edge==true use rising edge of input, otherwise falling edge.
   *  @return SUCCESS.
   */
  command result_t init( bool edge );

  /** setPreScale()
   *  Set the clock pre-scale and clock source value, default: internal /64
   * @param ps -- TCCR3B register set value.
   *		0 -- 000 No clock source. (Timer/Counter stopped)
   *		1 -- 001 clkI/O/1 (No prescaling
   *		2 -- 010 clkI/O/8 (From prescaler)
   *		3 -- 011 clkI/O/64 (From prescaler)
   *		4 -- 100 clkI/O/256 (From prescaler)
   *		5 -- 101 clkI/O/1024 (From prescaler)
   *		6 -- 110 External clock source on Tn pin. Clock on falling edge
   *		7 -- 111 External clock source on Tn pin. Clock on rising edge
   * @return nada.
   **/
  command void setPreScale( uint8_t ps );

  /** invertEdge()
   *   Invert the edge detect sense, if it was 1 it's 0 after, USW
   **/
  command void invertEdge();

  /**
   *  Disable Clock interrupt
   */
  async command void intDisable();

  /**
   *  Enable Clock interrupt
   */
  async command void intEnable() ;


  /**
   *  An event sent when the input interrupt goes off.
   *  Gets the count value and a counter overflow indicator.
   *  If over==true counter wrapped between last call and this.
   **/
  async event result_t fire( uint16_t count, bool over );

}
