/**	HPLPort.nc -- Interface for reading/writing a raw I/O port.
**/


interface HPLPort
{
	/**
	 * Initialize the module and port.
	 *  @param direction -- 0 == input, !0 == output
	 *  @return Always returns SUCCESS.
	*/
	command result_t init( uint8_t direction );

	/**
	 * read the value of an input port
	 *  @return  8 bit unsigned value.
	*/
	command uint8_t read();

	/**
	 * write the given 8 bit value to the port. 
	 *  @param value -- data to write
	 *  @return Always returns SUCCESS.
	*/
	command result_t write( uint8_t value );
}
