/** EncDrive.nc -- Example driver to use HSMotors encoders
**/

/** Wheel encoder bits on PortC -- A-left motor, B-right motor **/
#define	WENCA	0x20
#define	WENCB	0x80

	uint16_t ticks = 0;	// main clock counter
	uint16_t Aticks = 0;	// A encoder counter
	uint16_t Bticks = 0;	// B encoder counter
	uint8_t estate = 0;	// encoder edge detector state

	/**
	* Signaled when the clock ticks, 1/milli-sec.
	*  Always returns SUCCESS.
	**/
	event result_t Timer.fired()
	{	
		uint8_t temp;

		// use GREEN as a power and timer indicator
		call Leds.greenToggle();
		
		// incr time no matter what
		++ticks;

		temp = call PortC.read(); // get encoder switch inputs

		// deal with wheel encoder clicks on both sides
		//  detect rising edge and call speed'o'control with
		//  the number of timer ticks since the last edge
		// note: doesn't deal with tick counter wraparound
		//       or startup issues...jeez...it's only an example.
		if( (temp & WENCA) == 0 )
		{
			estate |= 1;
		}
		else if( estate & 1 )	// first sample that is 1
		{
			estate ^= 1;
			call HSMotors.checkASpeed( (uint8_t) ticks - Aticks );
			Aticks = ticks;		// save for next time
		}

		if( (temp & WENCB) == 0 )
		{
			estate |= 2;
		}
		else if( estate & 2 )	// first sample that is 1
		{
			estate ^= 2;
			call HSMotors.checkASpeed( (uint8_t) ticks - Bticks );
			Bticks = ticks;		// save for next time
		}

		return SUCCESS;	
	}
